#include <bits/stdc++.h>

struct Frilenser {
	double plata;
	double porez;

	bool operator<(const Frilenser& drugi) {
		return porez < drugi.porez;
	}
	bool operator>(const Frilenser& drugi) {
		return porez > drugi.porez;
	}
};

auto main() -> int {
	std::ios_base::sync_with_stdio(false);

	int n;
	std::cin >> n;

	std::vector<Frilenser> frilenseri(n);

	for (auto& f : frilenseri)
		std::cin >> f.plata >> f.porez;

	std::sort(begin(frilenseri), end(frilenseri));

	auto trenutni = begin(frilenseri);
	double max_zarada = 0.0d;

	while (trenutni != end(frilenseri)) {
		const double zarada = std::accumulate(trenutni, end(frilenseri), 0.0d, [](double sum, const auto& f) {
				return sum + f.plata;
		}) * trenutni->porez;

		max_zarada = std::max(max_zarada, zarada);

		auto sledeci = trenutni + 1;
		while (sledeci != end(frilenseri) && sledeci->porez == trenutni->porez)
			++sledeci;
		trenutni = sledeci;
	}

	std::printf("%.4f\n", max_zarada/100);
}